//------------------------------------------------------------------
#property copyright "mladen"
#property link      "mladenfx@gmail.com"
//------------------------------------------------------------------
#property indicator_separate_window
#property indicator_buffers    5
#property indicator_color1     Green
#property indicator_color2     DarkOrange
#property indicator_color3     LimeGreen
#property indicator_color4     Orange
#property indicator_color5     Orange
#property indicator_width1     2
#property indicator_width2     2
#property indicator_width3     2
#property indicator_width4     2
#property indicator_width5     2

//
//
//
//
//

extern string TimeFrame   = "Current time frame";
extern int    Length      = 32;
extern int    Price       = PRICE_TYPICAL;
extern double HighLowStep = 0.5;

//
//
//
//
//

double rsx[];
double rsxDa[];
double rsxDb[];
double slope[];
double max[];
double min[];

//
//
//
//
//

string indicatorFileName;
int    timeFrame;
bool   returnBars;
bool   calculateValue;

//-------------------------------------------------------------------
//
//-------------------------------------------------------------------
//
//
//
//
//

int init()
{
   IndicatorBuffers(6);
      SetIndexBuffer(0,max); SetIndexEmptyValue(0,0);
      SetIndexBuffer(1,min);
      SetIndexBuffer(2,rsx);
      SetIndexBuffer(3,rsxDa);
      SetIndexBuffer(4,rsxDb);
      SetIndexBuffer(5,slope);
      
       //
       //
       //
       //
       //
     
        indicatorFileName = WindowExpertName();
        calculateValue    = (TimeFrame=="calculateValue"); if (calculateValue) return(0);
        returnBars        = (TimeFrame=="returnBars");     if (returnBars)     return(0);
        timeFrame         = stringToTimeFrame(TimeFrame); 
        
      //
      //
      //
      //
      // 
     
   IndicatorShortName(timeFrameToString(timeFrame)+"  Rsx ("+Length+")");
return(0);
}

//
//
//
//
//

int deinit() { return(0); }

//-------------------------------------------------------------------
//
//-------------------------------------------------------------------
//
//
//
//
//

double wrkBuffer[][13];

int start()
{
   int i,r,counted_bars=IndicatorCounted();
      if(counted_bars<0) return(-1);
      if(counted_bars>0) counted_bars--;
         int limit = MathMin(Bars-counted_bars,Bars-1);
         if (returnBars) { rsx[0] = limit+1; return(0); }
         
   //
   //
   //
   //
   //
   
   if (calculateValue || timeFrame==Period())
   {
     double Kg = (3.0)/(2.0+Length); 
     double Hg = 1.0-Kg;
     if (slope[limit]==-1) CleanPoint(limit,rsxDa,rsxDb);
     if (ArrayRange(wrkBuffer,0) != Bars) ArrayResize(wrkBuffer,Bars);
     for(i=limit, r=Bars-i-1; i>=0; i--, r++)
     {
        wrkBuffer[r][12] = iMA(NULL,0,1,0,MODE_SMA,Price,i);
        if (i==(Bars-1)) { for (int c=0; c<12; c++) wrkBuffer[r][c] = 0; continue; }  

        //
        //
        //
        //
        //
      
        double mom = wrkBuffer[r][12]-wrkBuffer[r-1][12];
        double moa = MathAbs(mom);
        for (int k=0; k<3; k++)
        {
           int kk = k*2;
              wrkBuffer[r][kk+0] = Kg*mom                + Hg*wrkBuffer[r-1][kk+0];
              wrkBuffer[r][kk+1] = Kg*wrkBuffer[r][kk+0] + Hg*wrkBuffer[r-1][kk+1]; mom = 1.5*wrkBuffer[r][kk+0] - 0.5 * wrkBuffer[r][kk+1];
              wrkBuffer[r][kk+6] = Kg*moa                + Hg*wrkBuffer[r-1][kk+6];
              wrkBuffer[r][kk+7] = Kg*wrkBuffer[r][kk+6] + Hg*wrkBuffer[r-1][kk+7]; moa = 1.5*wrkBuffer[r][kk+6] - 0.5 * wrkBuffer[r][kk+7];
        }
        if (moa != 0)
             rsx[i] = MathMax(MathMin((mom/moa+1.0)*50.0,100.00),0.00); 
        else rsx[i] = 50;
        max[i] = MathMax(rsx[i],max[i+1]-HighLowStep);
        min[i] = MathMin(rsx[i],min[i+1]+HighLowStep);
      
        //
        //
        //
        //
        //
      
        rsxDa[i] = EMPTY_VALUE;
        rsxDb[i] = EMPTY_VALUE;
        slope[i] = slope[i+1];
            if (rsx[i]>rsx[i+1])  slope[i] = 1;
            if (rsx[i]<rsx[i+1])  slope[i] =-1;
            if (slope[i]==-1) PlotPoint(i,rsxDa,rsxDb,rsx); 
     }      
     return(0);
     }
     
     //
     //
     //
     //
     //
   
     limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrame,indicatorFileName,"returnBars",0,0)*timeFrame/Period()));
     if (slope[limit]==-1) CleanPoint(limit,rsxDa,rsxDb);
     for (i=limit;i>=0; i--)
     {
        int y = iBarShift(NULL,timeFrame,Time[i]);
           min[i]   = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",Length,Price,HighLowStep,0,y);
           max[i]   = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",Length,Price,HighLowStep,1,y);
           rsx[i]   = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",Length,Price,HighLowStep,2,y);
           slope[i] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",Length,Price,HighLowStep,5,y);
           rsxDa[i] = EMPTY_VALUE;
           rsxDb[i] = EMPTY_VALUE;
           if (slope[i]==-1) PlotPoint(i,rsxDa,rsxDb,rsx);
     }
return(0);
}

//-------------------------------------------------------------------
//
//-------------------------------------------------------------------
//
//
//
//
//

void CleanPoint(int i,double& first[],double& second[])
{
   if ((second[i]  != EMPTY_VALUE) && (second[i+1] != EMPTY_VALUE))
        second[i+1] = EMPTY_VALUE;
   else
      if ((first[i] != EMPTY_VALUE) && (first[i+1] != EMPTY_VALUE) && (first[i+2] == EMPTY_VALUE))
          first[i+1] = EMPTY_VALUE;
}

//
//
//
//
//

void PlotPoint(int i,double& first[],double& second[],double& from[])
{
   if (first[i+1] == EMPTY_VALUE)
      {
         if (first[i+2] == EMPTY_VALUE) {
                first[i]   = from[i];
                first[i+1] = from[i+1];
                second[i]  = EMPTY_VALUE;
            }
         else {
                second[i]   =  from[i];
                second[i+1] =  from[i+1];
                first[i]    = EMPTY_VALUE;
            }
      }
   else
      {
         first[i]  = from[i];
         second[i] = EMPTY_VALUE;
      }
}

//-------------------------------------------------------------------
//
//-------------------------------------------------------------------
//
//
//
//
//

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

//
//
//
//
//

int stringToTimeFrame(string tfs)
{
   tfs = stringUpperCase(tfs);
   for (int i=ArraySize(iTfTable)-1; i>=0; i--)
         if (tfs==sTfTable[i] || tfs==""+iTfTable[i]) return(MathMax(iTfTable[i],Period()));
                                                      return(Period());
}
string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}

//
//
//
//
//

string stringUpperCase(string str)
{
   string   s = str;

   for (int length=StringLen(str)-1; length>=0; length--)
   {
      int char = StringGetChar(s, length);
         if((char > 96 && char < 123) || (char > 223 && char < 256))
                     s = StringSetChar(s, length, char - 32);
         else if(char > -33 && char < 0)
                     s = StringSetChar(s, length, char + 224);
   }
   return(s);
}